//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace CLRUnleashed
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	public class G 
	{
		public int i;
		public G next;
	}
	class Unsafe
	{
		unsafe static void UnsafePointers() 
		{
			// pG to cay wskanik obiektu
			G pG = new G();
			// ipi to wewntrzny wskanik
			fixed(int* ipi = &(pG.i))
			{
				*ipi = 10;
			}
			// ppG to wewntrzny wskanik
			G ppG = pG.next;
			// *ppG to cay wskanik obiektu
			pG.next = new G();
		}

		unsafe static void StringAddress(string s)
		{
			fixed(char *p = s)
			{
				Console.WriteLine("0x{0:X8}", (uint)p);
			}       
		}
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			StringAddress("Jaki jest adres tego cigu?");
			UnsafePointers();
		}
	}
}
